/************************************************************************************************
*   深圳市摩西尔电子有限公司 @版本所有@
*
*   此文件用于测试 /page/ext_bright页面函数(硬件)
*
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.05.13
*      内容 : 所有代码
************************************************************************************************/

/* exported tc_record_evt_bright */
/* exported tc_record_time_bright */
/* exported tc_add_brightness */
/* exported tc_cancel_brightness */
/* exported tc_piecewise_brightness */
/* exported tc_send_brightness */
/* exported tc_readback_brightness */

/* global $ */
// /* global mc_sdk_param */
// 页面层级
// 顶层
var obj_bright_iframe_top = "";
// main层
var obj_bright_iframe_sub_main = "";
// 子页面层
var obj_bright_iframe_child_page = "";
// 子页面dom层 默认去界面第一层
var obj_bright_html_child_page = "";
// 子页面方面变量定义层
var obj_bright_window_child_page = "";

// 统一界面对比数据
var obj_jungle_same_data = {
    "evt_time_bright": [],
    "b_type": ""
};

// 页面数据
var obj_page_data = {

};

// 用于比较的数据
var obj_jungle_data = {

};

// 定义数据存储结构 表格数据
var obj_each_tbl_data = {
    "evt_time": "",
    "recv": ""
};

// 定义表格dom -> ul
var arr_ul = [];
// 定义模拟时间
var arr_time = ["01:01:01", "02:02:02", "03:03:03"];

// 定义数据比较结果
var arr_bright_jungle_result = [];

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试环境亮度记录功能
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-12
 *       内容 : 所有代码
************************************************************************************************/
function tc_record_evt_bright(callback) {
    // 先清掉缓存
    localStorage.removeItem("FUNCCARD_BRIGHT_CONFIG_DATA");
    // 清空界面
    mc_bright_clear_iframe_page();
    // 打开第一层的子页面 chip
    mc_bright_jungle_open_subpage(0, function () {
    // 打开环境亮度界面
        obj_bright_html_child_page.getElementsByClassName("mc_radio_item")[0].onmousedown();
        setTimeout(() => {
            mc_bright_jungle_open_subpage(1, function () {
                // 添加三个
                mc_add_tbl_row(3, function () {
                    var ui_tbl_val = "10";

                    for (var id_tbl_evt = 0; 3 > id_tbl_evt; id_tbl_evt++) {
                        var obj_each_jungle_data = JSON.parse(JSON.stringify(obj_each_tbl_data));

                        arr_ul = obj_bright_html_child_page.getElementsByClassName("table_row")[id_tbl_evt].children;

                        arr_ul[1].innerText = ui_tbl_val;
                        arr_ul[1].setAttribute("lang_id", ui_tbl_val);
                        arr_ul[2].innerText = ui_tbl_val;
                        arr_ul[2].setAttribute("lang_id", ui_tbl_val);
                        obj_each_jungle_data.evt_time = ui_tbl_val;
                        obj_each_jungle_data.recv = ui_tbl_val;
                        ui_tbl_val = (Number(ui_tbl_val) + 10) + "";
                        obj_jungle_data.evt_time_bright.push(obj_each_jungle_data);
                    }

                    obj_bright_window_child_page.onValchg();

                    // 修改类型 -> 关闭
                    obj_bright_window_child_page.obj_type.set_dom_val("MC_LANG_EXT_BRIGHT_CLOSE");
                    obj_bright_window_child_page.bright_type("", "MC_LANG_EXT_BRIGHT_CLOSE");

                    obj_jungle_data.b_type = "1";

                    setTimeout(() => {
                        // 关闭界面
                        mc_bright_remove_dialog_subpage("subpage", 1);
                        mc_bright_jungle_open_subpage(0, function () {
                            obj_bright_html_child_page.getElementsByClassName("mc_radio_item")[0].onmousedown();
                            setTimeout(() => {
                                mc_bright_jungle_open_subpage(1, function () {
                                    for (var idx_page_evt = 0; 3 > idx_page_evt; idx_page_evt++) {
                                        arr_ul = obj_bright_html_child_page.getElementsByClassName("table_row")[idx_page_evt].children;
                                        var obj_each_page_data = JSON.parse(JSON.stringify(obj_each_tbl_data));

                                        obj_each_page_data.evt_time = arr_ul[1].innerText;
                                        obj_each_page_data.recv = arr_ul[2].innerText;
                                        obj_page_data.evt_time_bright.push(obj_each_page_data);
                                    }

                                    // 获取类型
                                    obj_page_data.b_type = obj_bright_html_child_page.getElementsByClassName("mc_radio_btn ")[0].getAttribute("select_index");

                                    // 比较数据
                                    arr_bright_jungle_result = mc_bright_jungle_data(obj_page_data, obj_jungle_data);

                                    if (arr_bright_jungle_result[0]) {
                                        callback("1", "数据正确");
                                    } else {
                                        callback("0", arr_bright_jungle_result[1]);
                                    }
                                    return;

                                    // 获取界面数据
                                    // obj_bright_iframe_top;
                                    // obj_bright_iframe_sub_main;
                                    // obj_bright_iframe_child_page;
                                    // obj_bright_html_child_page;
                                    // obj_bright_window_child_page;
                                });
                            }, 1000);
                        });
                    }, 1000);
                });
            });
        }, 1000);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试定时亮度记录功能
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-12
 *       内容 : 所有代码
************************************************************************************************/
function tc_record_time_bright(callback) {
    // 先清掉缓存
    localStorage.removeItem("FUNCCARD_BRIGHT_TIME_DATA");
    localStorage.removeItem("FUNCCARD_BRIGHT_CONFIG_DATA");
    // 清空界面
    mc_bright_clear_iframe_page();
    // 打开第一层的子页面 chip
    mc_bright_jungle_open_subpage(0, function () {
    // 打开环境亮度界面
        obj_bright_html_child_page.getElementsByClassName("mc_radio_item")[1].onmousedown();
        setTimeout(() => {
            mc_bright_jungle_open_subpage(1, function () {
                // 添加三个
                mc_add_tbl_row(3, function () {
                    var ui_tbl_val = "10";

                    for (var id_tbl_evt = 0; 3 > id_tbl_evt; id_tbl_evt++) {
                        var obj_each_jungle_data = JSON.parse(JSON.stringify(obj_each_tbl_data));

                        arr_ul = obj_bright_html_child_page.getElementsByClassName("table_row")[id_tbl_evt].children;

                        // 执行获取设置定时界面的逻辑
                        arr_ul[1].children[0].value = arr_time[id_tbl_evt];
                        obj_bright_window_child_page.arr_time_all[id_tbl_evt] = arr_time[id_tbl_evt];
                        obj_bright_window_child_page.mc_set_local(1);
                        obj_each_jungle_data.evt_time = arr_time[id_tbl_evt];

                        // 设置接收卡亮度值
                        arr_ul[2].innerText = ui_tbl_val;
                        arr_ul[2].setAttribute("lang_id", ui_tbl_val);
                        obj_each_jungle_data.recv = ui_tbl_val;
                        ui_tbl_val = (Number(ui_tbl_val) + 10) + "";
                        obj_jungle_data.evt_time_bright.push(obj_each_jungle_data);
                    }

                    obj_bright_window_child_page.onValchg();

                    // 修改类型 -> 上位机
                    obj_bright_window_child_page.obj_type.set_dom_val("MC_LANG_EXT_BRIGHT_DATA_MACHINE");
                    obj_bright_window_child_page.bright_type("", "MC_LANG_EXT_BRIGHT_DATA_MACHINE");

                    obj_jungle_data.b_type = "3";

                    setTimeout(() => {
                        // 关闭界面
                        mc_bright_remove_dialog_subpage("subpage", 1);
                        mc_bright_jungle_open_subpage(0, function () {
                            obj_bright_html_child_page.getElementsByClassName("mc_radio_item")[1].onmousedown();
                            setTimeout(() => {
                                mc_bright_jungle_open_subpage(1, function () {
                                    for (var idx_page_evt = 0; 3 > idx_page_evt; idx_page_evt++) {
                                        arr_ul = obj_bright_html_child_page.getElementsByClassName("table_row")[idx_page_evt].children;
                                        var obj_each_page_data = JSON.parse(JSON.stringify(obj_each_tbl_data));

                                        obj_each_page_data.evt_time = arr_ul[1].children[0].value;
                                        obj_each_page_data.recv = arr_ul[2].innerText;
                                        obj_page_data.evt_time_bright.push(obj_each_page_data);
                                    }

                                    // 获取类型
                                    obj_page_data.b_type = obj_bright_html_child_page.getElementsByClassName("mc_radio_btn ")[0].getAttribute("select_index");

                                    // 比较数据
                                    arr_bright_jungle_result = mc_bright_jungle_data(obj_page_data, obj_jungle_data);

                                    if (arr_bright_jungle_result[0]) {
                                        callback("1", "数据正确");
                                    } else {
                                        callback("0", arr_bright_jungle_result[1]);
                                    }
                                    return;
                                });
                            }, 1000);
                        });
                    }, 1000);
                });
            });
        }, 1000);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试界面添加功能
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-12
 *       内容 : 所有代码
************************************************************************************************/
function tc_add_brightness(callback) {
    // 获取界面数据
    // 先清掉缓存
    localStorage.removeItem("FUNCCARD_BRIGHT_CONFIG_DATA");
    // 清空界面
    mc_bright_clear_iframe_page();
    // 打开第一层的子页面 chip
    mc_bright_jungle_open_subpage(0, function () {
    // 打开环境亮度界面
        obj_bright_html_child_page.getElementsByClassName("mc_radio_item")[0].onmousedown();
        setTimeout(() => {
            mc_bright_jungle_open_subpage(1, function () {
                setTimeout(() => {
                    mc_add_tbl_row(2, function () {
                        var ui_val = "1";
                        var html_ul = obj_bright_html_child_page.getElementsByClassName("table_row");
                        var obj_each_jungle_data = {};

                        for (var id_tbl_evt = 0; 2 > id_tbl_evt; id_tbl_evt++) {
                            obj_each_jungle_data = JSON.parse(JSON.stringify(obj_each_tbl_data));

                            arr_ul = html_ul[id_tbl_evt].children;

                            arr_ul[1].innerText = ui_val;
                            arr_ul[1].setAttribute("lang_id", ui_val);
                            arr_ul[2].innerText = ui_val;
                            arr_ul[2].setAttribute("lang_id", ui_val);
                            obj_each_jungle_data.evt_time = ui_val;
                            obj_each_jungle_data.recv = ui_val;
                            ui_val = (Number(ui_val) + 1) + "";
                            obj_jungle_data.evt_time_bright.push(obj_each_jungle_data);
                        }
                        obj_bright_window_child_page.onValchg();
                        // 添加一行在1和2之间
                        setTimeout(() => {
                            mc_choose_add_order(1, true, html_ul);
                            setTimeout(() => {
                                obj_each_jungle_data = JSON.parse(JSON.stringify(obj_each_tbl_data));
                                obj_jungle_data.evt_time_bright.splice(1, 0, obj_each_jungle_data);

                                // 获取界面内容
                                mc_get_page_tbl(html_ul, "page");

                                // 比较数据
                                arr_bright_jungle_result = mc_bright_jungle_data(obj_page_data, obj_jungle_data);

                                if (!arr_bright_jungle_result[0]) {
                                    callback("0", arr_bright_jungle_result[1]);
                                    return;
                                }

                                //取消选中添加到
                                mc_choose_add_order(1, false, html_ul);
                                setTimeout(() => {
                                    // 获取界面内容
                                    obj_page_data.evt_time_bright = [];
                                    mc_get_page_tbl(html_ul, "page");
                                    obj_each_jungle_data = JSON.parse(JSON.stringify(obj_each_tbl_data));
                                    obj_jungle_data.evt_time_bright.push(obj_each_jungle_data);

                                    // 比较数据
                                    arr_bright_jungle_result = mc_bright_jungle_data(obj_page_data, obj_jungle_data);

                                    if (!arr_bright_jungle_result[0]) {
                                        callback("0", arr_bright_jungle_result[1]);
                                    } else {
                                        callback("1", "数据正确");
                                    }
                                    return;
                                }, 2000);
                            }, 2000);
                        }, 1000);
                    });
                }, 1000);
            });
        }, 1000);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试界面删除功能
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-12
 *       内容 : 所有代码
************************************************************************************************/
function tc_cancel_brightness(callback) {
    // 先清掉缓存
    localStorage.removeItem("FUNCCARD_BRIGHT_CONFIG_DATA");
    // 清空界面
    mc_bright_clear_iframe_page();
    // 打开第一层的子页面 chip
    mc_bright_jungle_open_subpage(0, function () {
    // 打开环境亮度界面
        obj_bright_html_child_page.getElementsByClassName("mc_radio_item")[0].onmousedown();
        setTimeout(() => {
            mc_bright_jungle_open_subpage(1, function () {
                setTimeout(() => {
                    mc_add_tbl_row(6, function () {
                        var html_ul_cancel = obj_bright_html_child_page.getElementsByClassName("table_row");

                        var obj_each_jungle_data = {};
                        var ui_val = "1";

                        for (var id_tbl_evt = 0; 6 > id_tbl_evt; id_tbl_evt++) {
                            obj_each_jungle_data = JSON.parse(JSON.stringify(obj_each_tbl_data));

                            arr_ul = html_ul_cancel[id_tbl_evt].children;

                            arr_ul[1].innerText = ui_val;
                            arr_ul[1].setAttribute("lang_id", ui_val);
                            arr_ul[2].innerText = ui_val;
                            arr_ul[2].setAttribute("lang_id", ui_val);
                            obj_each_jungle_data.evt_time = ui_val;
                            obj_each_jungle_data.recv = ui_val;
                            ui_val = (Number(ui_val) + 1) + "";
                        }
                        mc_get_page_tbl(html_ul_cancel, "jungle");
                        obj_bright_window_child_page.onValchg();
                        setTimeout(() => {
                            // 删除 第3 6行
                            // 获取 第3 第6 span标签
                            var html_span_third = obj_bright_html_child_page.getElementsByClassName("mc_cancel_btn")[2];
                            var html_span_sixth = obj_bright_html_child_page.getElementsByClassName("mc_cancel_btn")[5];

                            obj_bright_window_child_page.mc_reduce_port(html_span_third);
                            obj_bright_window_child_page.mc_reduce_port(html_span_sixth);
                            setTimeout(() => {
                                obj_jungle_data.evt_time_bright.splice(2, 1);
                                obj_jungle_data.evt_time_bright.splice(4, 1);
                                mc_get_page_tbl(html_ul_cancel, "page");

                                // 比较数据
                                arr_bright_jungle_result = mc_bright_jungle_data(obj_page_data, obj_jungle_data);

                                if (!arr_bright_jungle_result[0]) {
                                    callback("0", arr_bright_jungle_result[1]);
                                } else {
                                    callback("1", "数据正确");
                                }
                                return;
                            }, 1000);
                        }, 1000);
                    });
                }, 1000);
            });
        }, 1000);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试分段功能
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-18
 *       内容 : 所有代码
************************************************************************************************/
function tc_piecewise_brightness(callback) {
    // 先清掉缓存
    localStorage.removeItem("FUNCCARD_BRIGHT_CONFIG_DATA");
    // 打开第一层的子页面 chip
    mc_bright_clear_iframe_page();
    mc_bright_jungle_open_subpage(0, function () {
    // 打开环境亮度界面
        obj_bright_html_child_page.getElementsByClassName("mc_radio_item")[0].onmousedown();
        setTimeout(() => {
            mc_bright_jungle_open_subpage(1, function () {
                obj_bright_window_child_page.mc_piecewise();
                setTimeout(() => {
                    mc_bright_jungle_open_subpage(2, function () {
                        obj_bright_window_child_page.ext_bright_left.set_dom_val("100");
                        obj_bright_window_child_page.ext_bright_right.set_dom_val("2000");
                        obj_bright_window_child_page.card_bright_left.set_dom_val("10");
                        obj_bright_window_child_page.card_bright_right.set_dom_val("50");
                        obj_bright_window_child_page.piecewish_slider.set_dom_val("8");
                        obj_bright_window_child_page.obj_data.ext_min = "100";
                        obj_bright_window_child_page.obj_data.ext_max = "2000";
                        obj_bright_window_child_page.obj_data.card_min = "10";
                        obj_bright_window_child_page.obj_data.card_max = "50";
                        obj_bright_window_child_page.obj_data.slider = "8";
                        setTimeout(() => {
                            obj_bright_window_child_page.on_clk_apply();
                            // 去掉分段界面
                            mc_bright_remove_dialog_subpage("subpage", 2);
                            mc_bright_jungle_open_subpage(1, function () {
                                obj_jungle_data.evt_time_bright = [{ "evt_time": "100", "recv": "10" }, { "evt_time": "337", "recv": "15" }, { "evt_time": "575", "recv": "20" }, { "evt_time": "812", "recv": "25" }, { "evt_time": "1050", "recv": "30" }, { "evt_time": "1287", "recv": "35" }, { "evt_time": "1525", "recv": "40" }, { "evt_time": "1762", "recv": "45" }, { "evt_time": "2000", "recv": "50" }];
                                var html_ul_cancel = obj_bright_html_child_page.getElementsByClassName("table_row");

                                mc_get_page_tbl(html_ul_cancel, "page");
                                // 比较数据
                                arr_bright_jungle_result = mc_bright_jungle_data(obj_page_data, obj_jungle_data);

                                if (!arr_bright_jungle_result[0]) {
                                    callback("0", arr_bright_jungle_result[1]);
                                } else {
                                    callback("1", "数据正确");
                                }
                                return;
                            });
                        }, 1000);
                    });
                }, 100);
            });
        }, 1000);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试发送功能
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-18
 *       内容 : 所有代码
************************************************************************************************/
function tc_send_brightness(callback) {
    // 先清掉缓存
    localStorage.removeItem("FUNCCARD_BRIGHT_CONFIG_DATA");
    // 打开第一层的子页面 chip
    mc_bright_clear_iframe_page();
    mc_bright_jungle_open_subpage(0, function () {
    // 打开环境亮度界面
        obj_bright_html_child_page.getElementsByClassName("mc_radio_item")[0].onmousedown();
        setTimeout(() => {
            mc_bright_jungle_open_subpage(1, function () {
                obj_bright_iframe_top;
                obj_bright_iframe_sub_main;
                obj_bright_iframe_child_page;
                obj_bright_html_child_page;
                obj_bright_window_child_page;

                mc_add_tbl_row(6, function () {
                    var html_ul_cancel = obj_bright_html_child_page.getElementsByClassName("table_row");

                    var obj_each_jungle_data = {};
                    var ui_val = "1";

                    for (var id_tbl_evt = 0; 6 > id_tbl_evt; id_tbl_evt++) {
                        obj_each_jungle_data = JSON.parse(JSON.stringify(obj_each_tbl_data));

                        arr_ul = html_ul_cancel[id_tbl_evt].children;

                        arr_ul[1].innerText = ui_val;
                        arr_ul[1].setAttribute("lang_id", ui_val);
                        arr_ul[2].innerText = ui_val;
                        arr_ul[2].setAttribute("lang_id", ui_val);
                        obj_each_jungle_data.evt_time = ui_val;
                        obj_each_jungle_data.recv = ui_val;
                        ui_val = (Number(ui_val) + 1) + "";
                    }

                    obj_bright_window_child_page.onValchg();
                    // 修改类型 -> 关闭
                    obj_bright_window_child_page.obj_type.set_dom_val("MC_LANG_EXT_BRIGHT_DATA_MACHINE");
                    obj_bright_window_child_page.bright_type("", "MC_LANG_EXT_BRIGHT_DATA_MACHINE");
                    obj_jungle_data.b_type = "3";

                    mc_get_page_tbl(html_ul_cancel, "jungle");
                    obj_bright_window_child_page.str_event = "send";

                    // 发送数据
                    obj_bright_window_child_page.mc_brightness_choose();

                    var str_send_data = obj_bright_window_child_page.parent.g_str_test_data;

                    // 比较数据
                    arr_bright_jungle_result = mc_jungle_send_get_hw_data(obj_jungle_data, str_send_data);

                    if (!arr_bright_jungle_result[0]) {
                        callback("0", arr_bright_jungle_result[1]);
                    } else {
                        callback("1", "数据正确");
                    }
                    return;
                });
            });
        }, 1000);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试回读功能
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-18
 *       内容 : 所有代码
************************************************************************************************/
function tc_readback_brightness(callback) {
    // 先清掉缓存
    localStorage.removeItem("FUNCCARD_BRIGHT_CONFIG_DATA");
    // 打开第一层的子页面 chip
    mc_bright_clear_iframe_page();
    mc_bright_jungle_open_subpage(0, function () {
    // 打开环境亮度界面
        obj_bright_html_child_page.getElementsByClassName("mc_radio_item")[0].onmousedown();
        setTimeout(() => {
            mc_bright_jungle_open_subpage(1, function () {
                obj_bright_window_child_page.str_event = "readback";

                // 发送数据
                obj_bright_window_child_page.mc_brightness_choose();
                obj_bright_window_child_page.obj_type.set_dom_val("MC_LANG_EXT_BRIGHT_DATA_MACHINE");
                obj_bright_window_child_page.bright_type("", "MC_LANG_EXT_BRIGHT_DATA_MACHINE");
                obj_bright_window_child_page.str_event = "send";

                var str_send_data = obj_bright_window_child_page.parent.g_str_test_data;

                setTimeout(() => {
                    var html_ul_cancel = obj_bright_html_child_page.getElementsByClassName("table_row");

                    mc_get_page_tbl(html_ul_cancel, "jungle");

                    if (!str_send_data) {
                        callback("1", "无数据返回,无法测试");
                        return;
                    }
                    // 比较数据
                    arr_bright_jungle_result = mc_jungle_send_get_hw_data(obj_jungle_data, str_send_data);

                    if (!arr_bright_jungle_result[0]) {
                        callback("0", arr_bright_jungle_result[1]);
                    } else {
                        callback("1", "数据正确");
                    }
                    return;
                }, 100);
            });
        }, 1000);
    });
}

/* -------------------------------------------------------------------公共处理函数----------------------------------------------------------------- */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理获取界面数据 仅用于添加功能测试用例
 * 参数:
 *    @param { Promise<string> } ui_cnt 添加表格数量
 *    @param { Promise<fun_callback> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-14
 *       内容 : 所有代码
************************************************************************************************/
function mc_add_tbl_row(ui_cnt, callback) {
    setTimeout(() => {
        for (var idx = 0; idx < ui_cnt; idx++) {
            obj_bright_html_child_page.getElementsByClassName("icon-plus")[0].onclick();
        }
        callback();
    }, 1000);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理获取界面数据 仅用于添加功能测试用例
 * 参数:
 *    @param { Promise<string> } html_dom_ul ul dom数
 *    @param { Promise<string> } str_type  需要获取界面的 数据变量
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    str_type 有两个参数 1.page 获取页面数据 2.jungle 获取比较的数据 两者都是获取界面数据 不同的是 jungle是在操作一遍界面之后的数据 page是最终界面显示的数据
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-14
 *       内容 : 所有代码
************************************************************************************************/
function mc_get_page_tbl(html_dom_ul, str_type) {
    // 获取界面内容
    var ui_tab_len = html_dom_ul.length;
    var ui_page_val;
    var obj_each_data = {};

    for (var idx = 0; idx < ui_tab_len; idx++) {
        obj_each_data = JSON.parse(JSON.stringify(obj_each_tbl_data));

        ui_page_val = html_dom_ul[idx].children[1].innerText;
        obj_each_data.evt_time = ui_page_val;
        obj_each_data.recv = ui_page_val;

        if ("page" === str_type) {
            obj_page_data.evt_time_bright.push(obj_each_data);
        } else if ("jungle" === str_type) {
            obj_jungle_data.evt_time_bright.push(obj_each_data);
        }
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    选择添加第几行/不添加行取消选中
 * 参数:
 *    @param { Promise<string> } ui_order 设置添加第几行
 *    @param { Promise<fun_callback> } b_if_choiced 设置是否选中
 *    @param { Promise<fun_callback> } html_ul_dom ul dom数
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-14
 *       内容 : 所有代码
************************************************************************************************/
function mc_choose_add_order(ui_order, b_if_choiced, html_ul_dom) {
    obj_bright_window_child_page.b_choose_one = b_if_choiced;
    if (b_if_choiced) {
        obj_bright_window_child_page.ui_select = ui_order;
        html_ul_dom[ui_order - 1].classList.add("show_ul_bright");
    } else {
        obj_bright_window_child_page.ui_select = null;
        html_ul_dom[ui_order - 1].classList.remove("show_ul_bright");
    }
    setTimeout(() => {
        obj_bright_window_child_page.mc_add_port();
    }, 2000);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    清空所有子页面 和弹框
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-11
 *       内容 : 所有代码
************************************************************************************************/
function mc_bright_clear_iframe_page() {
    obj_bright_iframe_top = document.getElementById("tifrem_led");
    obj_bright_iframe_sub_main = obj_bright_iframe_top.contentDocument.getElementById("iframe_subpage");
    obj_bright_iframe_child_page = obj_bright_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-iframe");

    var ui_iframe_page_cnt = obj_bright_iframe_child_page.length;

    // 提示弹框
    var arr_dialog_html = obj_bright_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog");

    if (0 < arr_dialog_html.length) {
        obj_bright_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog")[0].remove();
        obj_bright_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[0].remove();
    }
    for (var idx = 0; idx < ui_iframe_page_cnt; idx++) {
        obj_bright_iframe_child_page[0].remove();
        obj_bright_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[0].remove();
    }

    // 刷新数据
    obj_page_data = JSON.parse(JSON.stringify(obj_jungle_same_data));
    obj_jungle_data = JSON.parse(JSON.stringify(obj_jungle_same_data));
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断是否打开第三层子页面 以防同时测试多个时数据不对
 * 参数:
 *    @param { Promise<string> } idx_page 需打开第几个iframe界面
 *    @param { Promise<fun_callback> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-11
 *       内容 : 所有代码
************************************************************************************************/
function mc_bright_jungle_open_subpage(idx_page, callback) {
    obj_bright_iframe_top = document.getElementById("tifrem_led");
    obj_bright_iframe_sub_main = obj_bright_iframe_top.contentDocument.getElementById("iframe_subpage");
    obj_bright_iframe_child_page = obj_bright_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-iframe");
    var ui_iframe_len = obj_bright_iframe_child_page.length;

    if (0 === ui_iframe_len) {
    // 点击进入显示控制界面
        $(obj_bright_iframe_sub_main).contents().find("#mc_side_bright").click();
        setTimeout(() => {
            obj_bright_html_child_page = obj_bright_iframe_child_page[0].getElementsByTagName("iframe")[0].contentDocument;
            obj_bright_window_child_page = obj_bright_iframe_child_page[0].getElementsByTagName("iframe")[0].contentWindow;
            callback();
        }, 1000);
        return;
    }
    obj_bright_html_child_page = obj_bright_iframe_child_page[idx_page].getElementsByTagName("iframe")[0].contentDocument;
    obj_bright_window_child_page = obj_bright_iframe_child_page[idx_page].getElementsByTagName("iframe")[0].contentWindow;
    callback();
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    去掉提示弹窗/子页面弹窗
 * 参数:
 *    @param { Promise<string> } str_type 删除界面类型
 *    @param { Promise<number> } ui_type 删除第几个子页面
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-12
 *       内容 : 所有代码
************************************************************************************************/
function mc_bright_remove_dialog_subpage(str_type, ui_type) {
    // 弹框提示
    if ("dialog" === str_type) {
        obj_bright_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog")[0].remove();
        var ui_len_dialog = obj_bright_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade").length;

        // 去掉最后一个遮罩
        obj_bright_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[ui_len_dialog - 1].remove();
    }

    // 子页面 第三层
    if ("subpage" === str_type) {
        obj_bright_iframe_child_page[ui_type].remove();
        obj_bright_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[ui_type].remove();
    }

    // 子页面 第二层内 (主要是硬件选择界面)
    // if ("hw_page" === str_type) {
    //     obj_bright_iframe_child_page[1].remove();
    //     obj_bright_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[1].remove();
    // }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    比较数据 判断是否一致
 * 参数:
 *    @param { Promise<object> } page_data 界面最后显示的数据
 *    @param { Promise<object> } jungle_data 用于进行对比的正确数据
 * 返回:
 *    @return { Promise<Array> } arr_result 比较结果
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-12
 *       内容 : 所有代码
************************************************************************************************/
function mc_bright_jungle_data(page_data, jungle_data) {
    var arr_result = [true, ""];
    var str_page_type = Object.prototype.toString.call(page_data);
    var str_jungle_type = Object.prototype.toString.call(jungle_data);

    if (str_page_type !== str_jungle_type) {
        arr_result[0] = false;
        arr_result[1] = "前后数据格式不一致";
        return arr_result;
    }

    var ui_len_page = page_data.evt_time_bright.length;
    var ui_len_jungle = jungle_data.evt_time_bright.length;

    if (ui_len_page !== ui_len_jungle) {
        arr_result[0] = false;
        arr_result[1] = "数据长度比较不一致";
        return arr_result;
    }

    for (var id = 0; id < ui_len_page; id++) {
        var str_page_evt = page_data.evt_time_bright[id].evt_time;
        var str_page_recv = page_data.evt_time_bright[id].recv;
        var str_jungle_evt = page_data.evt_time_bright[id].evt_time;
        var str_jungle_recv = page_data.evt_time_bright[id].recv;

        if (str_page_evt !== str_jungle_evt || str_page_recv !== str_jungle_recv) {
            id += 1;
            arr_result[0] = false;
            arr_result[1] = "数据有误,在第" + id + "行";
            return arr_result;
        }
    }


    return arr_result;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    比较数据 判断是否一致
 * 参数:
 *    @param { Promise<object> } jungle_data 界面最后显示的数据
 *    @param { Promise<string> } str_dat 发送/回读的数据
 * 返回:
 *    @return { Promise<Array> } arr_result 比较结果
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-12
 *       内容 : 所有代码
************************************************************************************************/
function mc_jungle_send_get_hw_data(jungle_data, str_dat) {
    var arr_result = [true, ""];
    // 界面数据
    var arr_page_len = jungle_data.evt_time_bright;
    var ui_page_len = jungle_data.evt_time_bright.length;

    var arr_hw_data = str_dat.split(",");
    var ui_hw_len = arr_hw_data.length;

    if (ui_page_len !== ui_hw_len) {
        arr_result[0] = false;
        arr_result[1] = "数据长度比较不一致";
        return arr_result;
    }

    for (var idx = 0; idx < ui_page_len; idx++) {
        var arr_each_hw_data = arr_hw_data[idx].slice(1, -1).split(":");

        if (arr_page_len[idx].evt_time !== arr_each_hw_data[0] || arr_page_len[idx].recv !== arr_each_hw_data[1]) {
            idx += 1;
            arr_result[0] = false;
            arr_result[1] = "数据有误,在第" + idx + "行";
            return arr_result;
        }
    }
    return arr_result;
}

/* -------------------------------------------------------------------公共处理函数----------------------------------------------------------------- */

